org 100h
ITERS equ 4
BASECOLOR equ 10

  mov  al,12h   ; mode 640x480x16
  int  10h
  push 0A000h
  pop  es
  fninit

M:
  mov  dx,16
U:mov  cx,16

E:
V:call S   ; generate point(cx,dx) on sphere, store to (bx di)
  mov  si,bx
  mov  bp,di

  inc  dx
  call S
  dec  dx
  
  pusha
  call L   ; draw line from (bx*64,di*64) to (bx*64+cx,di*64+bp)
  popa
  inc  cx
  call S
  dec  cx
  call L

  add  word[T],44
  xor  byte[COL],BASECOLOR
  jnz  E
  sub  word[T],88

  loop V
  dec  dx
  jnz  U
  
  add  word[T],44

  mov  dx,3DAh
W:in   al,dx
  and  al,8
  jz   W

  in   al,60h
  cmp  al,1
  jnz  M
  
  ret
  
; generate point(cx,dx) on sphere, store to bx di

             ;       -2 4  6  8  10                 12 14 16
 ;pusha      ; push: ax cx dx bx sp(original value) bp si di

S:pusha
  fild  word[-2-2-4] ; A      ; saved cx
  fmul  dword[RR]
  ;fiadd word[T] ; a=A+t
  fsincos          ; ca sa
  fld   st0        ; ca ca sa
  fild  word[-2-2-6] ; B ca ca sa  ; saved dx
  fmul  dword[RR]
  fiadd word[T] ; b=B+t
  fsincos          ; cb sb ca ca sa
  fmulp st2,st0    ; sb ca*cb ca sa
  fmulp st2,st0    ; ca*cb y=ca*sb x=sa
  fiadd word[DEPTH]  ; z=ca*cb+D y x
  fidivr word[ZOOM]   ; zoom/z y x
  fmul  st1,st0    
  fmulp st2,st0    ; y/z*zoom x/z*zoom
  fistp word[-2-2-8] ; saved di
  fistp word[-2-2-16]; saved bx
  popa
  add  bx,320*16
  add  di,240*16
  ret
  
; draw line from (bx*16,di*16) to (si*16,bp*16)
L:mov  ax,0x0100<<ITERS  ; number of iters, green
COL equ $-2
  sub  si,bx
  sar  si,ITERS  ;dx
  sub  bp,di     ;dy
  sar  bp,ITERS
X:pusha  ; bx=x*16 di=y*16 al=color   (10.6)

  shr  di,4
  shr  bx,4
  mov  cl,7
  and  cl,bl      ; cl = x&7
  shr  bx,3 

  imul di,80      ; offset = y*(w/8) + x/8
  
  push ax
  mov  dx,3CEh    ; video hardware controller
  mov  ax,0x8008
  shr  ah,cl      ; 0xMM08, MM = 0x80>>(x&7)
  out  dx,ax
  mov  ax,0x0205  ; read mode 0, write mode 2
  out  dx,ax
  
  mov  ah,[es:bx+di] ; load to latch
  
  pop  ax
  mov  [es:bx+di],al ; write to register
  
  popa
  
  add  bx,si ; advance
  add  di,bp
N:dec  ah
  jnz  X
  ret


ZOOM  dw 5000
DEPTH dw 2
;RR dd 0.196349540849362077403915211454969 ; 2*pi/32
RR dd 0.392699081698724154807830422909938 ; 2*pi/16

section .bss
T resw 1
